
/**
 ******************************************************************************
 *
 * @file        MG32x02z_USBD_MGData.c
 * @brief       The code is Megawin AP TX/RX data C file.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_USB_DRV.h"
#include "MG32x02z_USBD_Core.h"
#include "MG32x02z_USBD_MGData.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
MGData_TypeDef    MGData_CTR;

/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
void USB_MGCTR_GetFeatureHandle(void)
{
    Ep0.All = 0;
    
    switch( MGData_CTR.Status & MGDATA_CTRTYPE_MASK)
    {
        case MGDATA_CTRTYPE_CALENDAR_UPDATE:
                                            
                                            if( MGData_CTR.Status & MGDATA_CTRSTATUS_RY)
                                            {
                                                MGData_CTR.Status = ( MGDATA_CTRTYPE_CALENDAR_UPDATE | MGDATA_CTRSTATUS_RY);
                                                
                                                Ep0.RxTx[0] = MGDATA_CMD_READ_APSTATUS;
                                                Ep0.RxTx[1] = MGDATA_SCMD_READ_CALENDAR;
                                                Ep0.Buf     = &Ep0.RxTx[0];
                                                
                                                MGData_CTR.Status = (MGDATA_CTRTYPE_CALENDAR_UPDATE | MGDATA_CTRSTATUS_DATA);
                                                
                                                Ep0.All = 2;
                                            }
                                            
                                            break;
        default:
                                            MGData_CTR.Status = MGDATA_CTRTYPE_IDLE;
                                            break;
    }
}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
void USB_MGCTR_SetFeatureHandle(void)
{
    ctype   SF_cTmp;
    uint8_t SF_Tmp   = MGData_CTR.Status & MGDATA_CTRTYPE_MASK;
    uint8_t SF_BLen;
    
    SF_BLen = (uint8_t)USB_GetEndpointRXSize(USB_EP0);
    USB_ReadEndpointData(USB_EP0 , Ep0.RxTx ,0, SF_BLen);
    
    
    switch(SF_Tmp)
    {
        case MGDATA_CTRTYPE_CALENDAR_UPDATE:
                                            if( Ep0.RxTx[0] == MGDATA_CMD_READ_APSTATUS && Ep0.RxTx[1] == MGDATA_SCMD_READ_CALENDAR)
                                            {
                                                USB_MGCTR_UpdateCalendarCallback( &Ep0.RxTx[2]);
                                                MGData_CTR.Status = MGDATA_CTRTYPE_IDLE;
                                                break;
                                            }
                                            USB_MGCTR_ErrorUpdateCalendar();
                                            break;
        case MGDATA_CTRSTATUS_IDLE:
                                            if( Ep0.RxTx[0] == DFU_RESET)
                                            {
                                                Ep0.DataStage = Ep0.RxTx[0];
                                                USB_SetEndpointTXSize(USB_EP0, 0);
                                                USB_SetEndpointStatus(USB_EP0, EP_TX_VALID); 
                                                return;
                                            }
                                            else if( Ep0.RxTx[0] == MGDATA_CMD_HOST_CMD )
                                            {
                                                if( Ep0.RxTx[1] == MGDATA_SCMD_HOST_DOWNLOAD)
                                                {
                                                    SF_cTmp.B[0]        = Ep0.RxTx[3];
                                                    SF_cTmp.B[1]        = Ep0.RxTx[4];
                                                    SF_cTmp.B[2]        = Ep0.RxTx[5];
                                                    SF_cTmp.B[3]        = Ep0.RxTx[6];
                                                    MGData_CTR.RX_Index = Ep0.RxTx[2];
                                                    MGData_CTR.RX_Total = SF_cTmp.W;
                                                    
                                                    USB_MGCTR_HostDownloadReadyCallback(MGData_CTR.RX_Index , MGData_CTR.RX_Total);
                                                    
                                                    MGData_CTR.Status = MGDATA_CTRTYPE_HOSTDOWNLOAD;
                                                }
                                                else if( Ep0.RxTx[1] == MGDATA_SCMD_HOST_SYNC)
                                                {
                                                    MGData_CTR.AP_Connect = 1;
                                                }
                                            }
                                            else
                                            {
                                                USB_MGCTR_ErrorCommandCallback();
                                                USB_MGCTR_Init();
                                            }
                                            break;
        case MGDATA_CTRTYPE_HOSTDOWNLOAD:
                                            if( (Ep0.RxTx[0] == MGDATA_CMD_DATA) && (Ep0.RxTx[1] == MDDATA_SCMD_DATA))
                                            {
                                                SF_Tmp  = (SF_BLen - 2);

                                                if( MGData_CTR.RX_Total < SF_Tmp)
                                                {
                                                    USB_MGCTR_HostDownloadCompleteCallback( &(Ep0.RxTx[2]), ((uint8_t)MGData_CTR.RX_Total));
                                                    
                                                    MGData_CTR.RX_Total = 0;
                                                    MGData_CTR.Status   = MGDATA_CTRSTATUS_IDLE;
                                                }
                                                else
                                                {
                                                    USB_MGCTR_HostDownloadCompleteCallback( &(Ep0.RxTx[2]), SF_Tmp);
                                                    
                                                    MGData_CTR.RX_Total = MGData_CTR.RX_Total - SF_Tmp;
                                                }
                                                break;   
                                            }
                                            USB_MGCTR_ErrorSubCommandCallback();
                                            break;
        default:
                                            USB_MGCTR_Init();
                                            break;
    }
    
    Ep0.All = Ep0.All - SF_BLen;
    if(Ep0.All==0)
    {
        Ep0.DataStage = STATUSSTAGE;
    }
    USB_SetEndpointTXSize(USB_EP0, 0);
    USB_SetEndpointStatus(USB_EP0, EP_RX_VALID_TX_VALID);
    
}
 /**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
void USB_MGCTR_Init(void)
{
    MGData_CTR.RX_Total   = 0;
    MGData_CTR.AP_Connect = 0;
    MGData_CTR.Status = ( MGDATA_CTRTYPE_IDLE | MGDATA_CTRSTATUS_IDLE);
}  
 /**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */

uint8_t USB_MGCTR_TriggerUpdateCalendar(void)
{
    if( MGData_CTR.Status != MGDATA_CTRTYPE_IDLE)
    {
        return(MGDATA_FAILURE);
    }
    else
    {
        MGData_CTR.Status =  (MGDATA_CTRTYPE_CALENDAR_UPDATE | MGDATA_CTRSTATUS_RY);
        return(MGDATA_SUCCESS);
    }
}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_UpdateCalendarCallback(uint8_t *CalendarData)
{
    //=========================================================
    //Prevent unused argument compilcation warning
    ((void)(CalendarData));
    
    //=========================================
    //Calendar update in :
    // Byte0 is Year low byte 
    // Byte1 is Year high byte
    // Byte2 is Month
    // Byte3 is Day
    // Byte4 is Hour
    // Byte5 is Minute
    // Byte6 is Second
}
/**
 *******************************************************************************
 * @brief	   AP ready to download date for device.
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_HostDownloadReadyCallback( uint8_t HostDL_Index , uint32_t HostDL_TotalSize)
{
    //=========================================================
    //Prevent unused argument compilcation warning
    ((void)(HostDL_Index));
    ((void)(HostDL_TotalSize));
    
    //================================================
    //Read the following parameter to know host download relationship information.
    //    1. HostDL_Index : User define information.
    //    2. HostDL_TotalSize : Total size of the download. 
    
    __NOP();
}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_HostDownloadContinuousCallback( uint8_t* HostDLBuf , uint8_t HostDL_BLen)
{
    //=========================================================
    //Prevent unused argument compilcation warning
    ((void)(HostDLBuf));
    ((void)(HostDL_BLen));
    
    __NOP();
}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_HostDownloadCompleteCallback(uint8_t* HostDLBuf , uint8_t HostDL_BLen)
{
    //=========================================================
    //Prevent unused argument compilcation warning
    ((void)(HostDLBuf));
    ((void)(HostDL_BLen));
    
    __NOP();
}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_ErrorUpdateCalendar(void)
{
    __NOP();
}
/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_ErrorCommandCallback(void)
{
    __NOP();
}

/**
 *******************************************************************************
 * @brief	    
 * @details     
 * @return      
 * @exception   
 * @note      
 * @par         
 *******************************************************************************
 */
__weak void USB_MGCTR_ErrorSubCommandCallback(void)
{
    __NOP();
}













